/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import io.github.fabricators_of_create.porting_lib.util.client.ScreenUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.joml.Matrix4f;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.screen.book.BookScreen;

public class TextComponentDataRenderer {
    public static String drawText(class_332 guiGraphics, int x, int y, int boxWidth, int boxHeight, TextComponentData[] data, int mouseX, int mouseY, class_327 fr, List<class_2561> tooltip) {
        String action = "";
        int atX = x;
        int atY = y;
        float prevScale = 1.0f;
        for (TextComponentData item : data) {
            boolean mouseCheck;
            int box1W = 9999;
            Objects.requireNonNull(fr);
            int box1H = y + 9;
            int box2Y = 9999;
            int box3X = 9999;
            int box3Y = 9999;
            if (item == null || item.text == null) continue;
            if (item.text.getString().equals("\n")) {
                atX = x;
                Objects.requireNonNull(fr);
                atY += 9;
                continue;
            }
            if (item.isParagraph) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + (float)(9 * 2) * prevScale);
            }
            prevScale = item.scale;
            List<class_5348> textLines = TextComponentDataRenderer.splitTextComponentBySize(item.text, boxWidth, boxHeight - (atY - y), boxWidth - (atX - x), fr, item.scale);
            int box1X = atX;
            int box1Y = atY;
            int box2X = x;
            int box2W = x + boxWidth;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                if (lineNumber == textLines.size() - 1) {
                    box3X = atX;
                    box3Y = atY;
                }
                class_5348 textComponent = textLines.get(lineNumber);
                TextComponentDataRenderer.drawScaledTextComponent(guiGraphics, fr, textComponent, atX, atY, item.dropShadow, item.scale);
                if (lineNumber < textLines.size() - 1) {
                    Objects.requireNonNull(fr);
                    atY += 9;
                    atX = x;
                }
                if (lineNumber != 0) continue;
                box2Y = atY;
                box1W = atX == x ? x + boxWidth : atX;
            }
            int box2H = atY;
            if ((atX = (int)((float)atX + (float)fr.method_30880(class_2477.method_10517().method_30934(textLines.get(textLines.size() - 1))) * item.scale)) - x >= boxWidth) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + 9.0f * item.scale);
            }
            int box3W = atX;
            float f = atY;
            Objects.requireNonNull(fr);
            int box3H = (int)(f + 9.0f * item.scale);
            boolean bl = mouseCheck = mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H;
            if (item.tooltips != null && item.tooltips.length > 0) {
                if (BookScreen.debug) {
                    Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
                    ScreenUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box1X, (int)box1Y, (int)box1W, (int)box1H, (int)-16711936, (int)-16711936);
                    ScreenUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box2X, (int)box2Y, (int)box2W, (int)box2H, (int)-65536, (int)-65536);
                    ScreenUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box3X, (int)box3Y, (int)box3W, (int)box3H, (int)-16776961, (int)-16776961);
                    ScreenUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)mouseX, (int)mouseY, (int)(mouseX + 5), (int)(mouseY + 5), (int)-65281, (int)-256);
                }
                if (mouseCheck) {
                    tooltip.addAll(Arrays.asList(item.tooltips));
                }
            }
            if (item.action != null && !item.action.isEmpty() && mouseCheck) {
                action = item.action;
            }
            if (atY >= y + boxHeight) {
                if (item.dropShadow) {
                    guiGraphics.method_25303(fr, "...", atX, atY, 0);
                    break;
                }
                guiGraphics.method_51433(fr, "...", atX, atY, 0, false);
                break;
            }
            y = atY;
        }
        if (BookScreen.debug && !action.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)class_2561.method_43470((String)("Action: " + action)).method_27692(class_124.field_1080));
        }
        return action;
    }

    public static List<class_5348> splitTextComponentBySize(class_2561 textComponent, int width, int height, int firstWidth, class_327 fontRenderer, float scale) {
        ArrayList<Object> textLines;
        boolean needsWrap;
        block6: {
            block5: {
                int curWidth = (int)((float)fontRenderer.method_27525((class_5348)textComponent) * scale);
                Objects.requireNonNull(fontRenderer);
                int curHeight = (int)(9.0f * scale);
                needsWrap = false;
                textLines = new ArrayList<class_5348>();
                Objects.requireNonNull(fontRenderer);
                if (curHeight == (int)(9.0f * scale) && curWidth > firstWidth) break block5;
                Objects.requireNonNull(fontRenderer);
                if (curHeight == (int)(9.0f * scale) || curWidth <= width) break block6;
            }
            needsWrap = true;
        }
        if (needsWrap) {
            textLines = new ArrayList(fontRenderer.method_27527().method_27495((class_5348)textComponent, firstWidth, class_2583.field_24360));
        } else {
            textLines.add((class_5348)textComponent);
        }
        return textLines;
    }

    public static void drawScaledTextComponent(class_332 guiGraphics, class_327 font, class_5348 textComponent, float x, float y, boolean dropShadow, float scale) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x, y, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        if (dropShadow) {
            guiGraphics.method_35720(font, class_2477.method_10517().method_30934(textComponent), 0, 0, 0);
        } else {
            guiGraphics.method_51430(font, class_2477.method_10517().method_30934(textComponent), 0, 0, 0, false);
        }
        guiGraphics.method_51448().method_22909();
    }
}

